#!/usr/bin/env python3
#
# Copyright (C) 2016 g10 Code GmbH
# Copyright (C) 2004,2008 Igor Belyi <belyi@users.sourceforge.net>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, see <https://www.gnu.org/licenses/>.

# Sample of unattended signing/verifying of a message.
# It uses keys for joe+gpg@example.org generated by genkey.py script

from __future__ import absolute_import, print_function, unicode_literals

import sys
import gpg
from gpg.constants.sig import mode

del absolute_import, print_function, unicode_literals

user = "joe+gpg"

with gpg.Context(pinentry_mode=gpg.constants.PINENTRY_MODE_LOOPBACK) as c:
    keys = list(c.keylist(user))
    if len(keys) == 0:
        sys.exit("No key matching {}.".format(user))

    c.signers = keys[:1]
    c.set_passphrase_cb(lambda *args: "Crypt0R0cks")
    signed_data, _ = c.sign(b"Test message", mode=mode.CLEAR)

    data, result = c.verify(signed_data, verify=keys[:1])
    print("Data: {!r}\nSignature: {!s}".format(data, result.signatures[0]))
