# coding: utf-8
from __future__ import print_function, unicode_literals

import argparse
import os
import signal
import sys
import threading

import queue

from .__init__ import ANYWIN
from .authsrv import AuthSrv
from .broker_util import BrokerCli, ExceptionalQueue, NotExQueue
from .fsutil import ramdisk_chk
from .httpsrv import HttpSrv
from .util import FAKE_MP, Daemon, HMaccas

class MpWorker(BrokerCli):
    "a"

    def __init__(
        self,
        q_pend   ,
        q_yield   ,
        args ,
        n ,
    )  :
        super(MpWorker, self).__init__()

        self.q_pend = q_pend
        self.q_yield = q_yield
        self.args = args
        self.n = n

        self.log = self._log_disabled if args.q and not args.lo else self._log_enabled

        self.retpend   = {}
        self.retpend_mutex = threading.Lock()
        self.mutex = threading.Lock()

        if not FAKE_MP:
            sigs = [signal.SIGINT, signal.SIGTERM]
            if not ANYWIN:
                sigs.append(signal.SIGUSR1)

            for sig in sigs:
                signal.signal(sig, self.signal_handler)

        self.asrv = AuthSrv(args, None, False)
        ramdisk_chk(self.asrv)

        self.iphash = HMaccas(os.path.join(self.args.E.cfg, "iphash"), 8)
        self.httpsrv = HttpSrv(self, n)

        Daemon(self.main, "mpw-main").join()

    def signal_handler(self, sig , frame )  :

        pass

    def _log_enabled(self, src , msg , c   = 0)  :
        self.q_yield.put((0, "log", [src, msg, c]))

    def _log_disabled(self, src , msg , c   = 0)  :
        pass

    def logw(self, msg , c   = 0)  :
        self.log("mp%d" % (self.n,), msg, c)

    def main(self)  :
        while True:
            retq_id, dest, args = self.q_pend.get()

            if dest == "retq":

                with self.retpend_mutex:
                    retq = self.retpend.pop(retq_id)

                retq.put(args)
                continue

            if dest == "shutdown":
                self.httpsrv.shutdown()
                self.logw("ok bye")
                sys.exit(0)
                return

            if dest == "reload":
                self.logw("mpw.asrv reloading")
                self.asrv.reload()
                ramdisk_chk(self.asrv)
                self.logw("mpw.asrv reloaded")
                continue

            if dest == "reload_sessions":
                with self.asrv.mutex:
                    self.asrv.load_sessions()
                continue

            obj = self
            for node in dest.split("."):
                obj = getattr(obj, node)

            rv = obj(*args)
            if retq_id:
                self.say("retq", rv, retq_id=retq_id)

    def ask(self, dest , *args )   :
        retq = ExceptionalQueue(1)
        retq_id = id(retq)
        with self.retpend_mutex:
            self.retpend[retq_id] = retq

        self.q_yield.put((retq_id, dest, list(args)))
        return retq

    def say(self, dest , *args , retq_id=0)  :
        self.q_yield.put((retq_id, dest, list(args)))
