
![CasaOS LinuxServer AppStore](https://raw.githubusercontent.com/WisdomSky/CasaOS-LinuxServer-AppStore/main/banner.png)

# CasaOS LinuxServer AppStore

A CasaOS custom Appstore containing over 100+ [LinuxServer.io](https://www.linuxserver.io/) images.


---

## 📃 Table of Contents

- [Introduction](#-introduction)
- [Installation](#-installation)
- [List of Applications](#-list-of-applications)
- [Contributing](#contributing)

---

## 🔥 Introduction

The **LinuxServer AppStore** is a custom appstore built to work for [CasaOS](https://github.com/IceWhaleTech/CasaOS).

This custom appstore for CasaOS contains a wide variety of configurations of docker images built and maintained by the [linuxserver.io](https://www.linuxserver.io/) community which are adapted to work for CasaOS.

The LinuxServer Appstore is **guaranteed to provide you the latest version of every Application** as the appstore automatically tracks new releases and updates the contents of this repository daily.

---
### 💎 CasaOS LinuxServer Appstore URL

    https://casaos-appstore.paodayag.dev/linuxserver.zip

## ✅ Installation

- Go to your CasaOS dashboard.

  ![Step 1](https://raw.githubusercontent.com/WisdomSky/CasaOS-LinuxServer-AppStore/main/tip-1.jpg)

- Open the appstore and click `Add Source` button  located on the right just above the apps list.

  ![Step 2](https://raw.githubusercontent.com/WisdomSky/CasaOS-LinuxServer-AppStore/main/tip-2.jpg)

- Paste the appstore link `https://casaos-appstore.paodayag.dev/linuxserver.zip` and then click `Add` to submit.

  ![Step 3](https://raw.githubusercontent.com/WisdomSky/CasaOS-LinuxServer-AppStore/main/tip-3.jpg)

- Wait for the installation to finish. Done!

> **NOTE: Custom Appstore is only supported on CasaOS version [0.4.4](https://blog.casaos.io/blog/32.html) and above. How to upgrade? [Click here](#-how-to-upgrade-casaos)**

---

## 🛠 List of Applications

| # | Application  | Version | Description |
| --- | --- | --- | --- |
| 1 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/adguardhomesync-icon.png" width="15"/>&nbsp;&nbsp;&nbsp;[Adguardhome sync](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Adguardhome-sync) | 0.8.2 | A tool to synchronize AdGuardHome config to replica instances. |
| 2 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/airsonic-banner.png" width="15"/>&nbsp;&nbsp;&nbsp;[Airsonic advanced](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Airsonic-advanced) | 11.1.4 | A free, web-based media streamer, providing ubiquitious access to your music. Use it to share your music with friends, or to listen to your own music while at work. You can stream to multiple players simultaneously, for instance to one player in your kitchen and another in your living room. |
| 3 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/altus-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Altus](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Altus) | 5.7.2 | An Electron-based WhatsApp client with themes and multiple account support. |
| 4 | <img src="https://raw.githubusercontent.com/caronc/apprise-api/master/apprise_api/static/logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Apprise api](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Apprise-api) | 1.3.1 | Takes advantage of Apprise through your network with a user-friendly API. * Send notifications to more than 100 services. * An incredibly lightweight gateway to Apprise. * A production ready micro-service at your disposal. * A Simple Website to verify and test your configuration with. Apprise API was designed to easily fit into existing (and new) eco-systems that are looking for a simple notification solution. |
| 5 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/ardour-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Ardour](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Ardour) | version-2025-07-12 | An open source, collaborative effort of a worldwide team including musicians, programmers, and professional recording engineers. |
| 6 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/audacity-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Audacity](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Audacity) | 3.7.7 | An easy-to-use, multi-track audio editor and recorder. Developed by a group of volunteers as open source. |
| 7 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/azahar-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Azahar](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Azahar) | 12123.4.1 | An open-source 3DS emulator based on Citra. |
| 8 | <img src="https://github.com/linuxserver/docker-templates/raw/master/linuxserver.io/img/babybuddy-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Babybuddy](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Babybuddy) | 2.7.1 | A buddy for babies. Helps caregivers track sleep, feedings, diaper changes, tummy time and more to learn about and predict baby's needs without (as much) guess work. |
| 9 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/bambustudio-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Bambustudio](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Bambustudio) | 02.05.00 | An open-source, cutting-edge, feature-rich slicing software. It contains project-based workflows, systematically optimized slicing algorithms, and an easy-to-use graphical interface, bringing users an incredibly smooth printing experience. |
| 10 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/bazarr.png" width="15"/>&nbsp;&nbsp;&nbsp;[Bazarr](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Bazarr) | 1.5.5 | A companion application to Sonarr and Radarr. It can manage and download subtitles based on your requirements. You define your preferences by TV show or movie and Bazarr takes care of everything for you. |
| 11 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/beets-icon.png" width="15"/>&nbsp;&nbsp;&nbsp;[Beets](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Beets) | 2.6.1 | A music library manager and not, for the most part, a music player. It does include a simple player plugin and an experimental Web-based player, but it generally leaves actual sound-reproduction to specialized tools. |
| 12 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/bitcoin-knots-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Bitcoin knots](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Bitcoin-knots) | version-29.3.knots20260210-noble1 | Can be used as a desktop client for regular payments or as a full node server utility for merchants and other payment services. |
| 13 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/blender-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Blender](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Blender) | 5.0.1 | A free and open-source 3D computer graphics software toolset used for creating animated films, visual effects, art, 3D printed models, motion graphics, interactive 3D applications, virtual reality, and computer games. This image does not support GPU rendering out of the box only accelerated workspace experience |
| 14 | <img src="https://raw.githubusercontent.com/BOINC/boinc/master/doc/logo/boinc_logo_black.jpg" width="15"/>&nbsp;&nbsp;&nbsp;[Boinc](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Boinc) | 8.2.8 | A platform for high-throughput computing on a large scale (thousands or millions of computers). It can be used for volunteer computing (using consumer devices) or grid computing (using organizational resources). It supports virtualized, parallel, and GPU-based applications. |
| 15 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/bookstack-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Bookstack](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Bookstack) | 25.12.3 | A free and open source Wiki designed for creating beautiful documentation. Featuring a simple, but powerful WYSIWYG editor it allows for teams to create detailed and useful documentation with ease. Powered by SQL and including a Markdown editor for those who prefer it, BookStack is geared towards making documentation more of a pleasure than a chore. For more information on BookStack visit their website and check it out: https://www. Bookstackapp. Com |
| 16 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/brave-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Brave](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Brave) | 1.87.188 | A fast, private and secure web browser for PC, Mac and mobile. |
| 17 | <img src="https://cdn.jsdelivr.net/gh/WisdomSky/CasaOS-LinuxServer-AppStore@main/default-icon.svg" width="15"/>&nbsp;&nbsp;&nbsp;[Budge](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Budge) | 0.0.9 | An open source 'budgeting with envelopes' personal finance app. |
| 18 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/calibre-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Calibre](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Calibre) | 9.2.1 | A powerful and easy to use e-book manager. Users say it's outstanding and a must-have. It'll allow you to do nearly everything and it takes things a step beyond normal e-book software. It's also completely free and open source and great for both casual users and computer experts. |
| 19 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/calibre-web-icon.png" width="15"/>&nbsp;&nbsp;&nbsp;[Calibre web](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Calibre-web) | 0.6.26 | A web app providing a clean interface for browsing, reading and downloading eBooks using an existing Calibre database. It is also possible to integrate google drive and edit metadata and your calibre library through the app itself. This software is a fork of library and licensed under the GPL v3 License. |
| 20 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/calligra-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Calligra](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Calligra) | 3.2.1 | An office and graphic art suite by KDE. It is available for desktop PCs, tablet computers, and smartphones. It contains applications for word processing, spreadsheets, presentation, vector graphics, and editing databases. |
| 21 | <img src="https://github.com/linuxserver/docker-templates/raw/master/linuxserver.io/img/changedetection-icon.png" width="15"/>&nbsp;&nbsp;&nbsp;[Changedetection. Io](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Changedetection.-Io) | 0.52.9 | Provides free, open-source web page monitoring, notification and change detection. |
| 22 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/chrome-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Chrome](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Chrome) | 145.0.7632 | The official web browser from Google, built to be fast, secure, and customizable. |
| 23 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/chromium-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Chromium](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Chromium) | version-c940bec2 | An open-source browser project that aims to build a safer, faster, and more stable way for all users to experience the web. |
| 24 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/citron-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Citron](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Citron) | 2026.02.1 | A feature rich Switch 1 emulator for homebrew. |
| 25 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/code-server-banner.png" width="15"/>&nbsp;&nbsp;&nbsp;[Code server](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Code-server) | 4.109.2 | VS Code running on a remote server, accessible through the browser. - Code on your Chromebook, tablet, and laptop with a consistent dev environment. - If you have a Windows or Mac workstation, more easily develop for Linux. - Take advantage of large cloud servers to speed up tests, compilations, downloads, and more. - Preserve battery life when you're on the go. - All intensive computation runs on your server. - You're no longer running excess instances of Chrome. |
| 26 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/cops-icon.png" width="15"/>&nbsp;&nbsp;&nbsp;[Cops](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Cops) | 4.2.0 | By Sébastien Lucas, now maintained by MikesPub, stands for Calibre OPDS (and HTML) Php Server. COPS links to your Calibre library database and allows downloading and emailing of books directly from a web browser and provides a OPDS feed to connect to your devices. Changes in your Calibre library are reflected immediately in your COPS pages. See : COPS's home for more details. Don't forget to check the Wiki. ## Why. (taken from the author's site) In my opinion Calibre is a marvelous tool but is too big and has too much dependencies to be used for its content server. That's the main reason why I coded this OPDS server. I needed a simple tool to be installed on a small server (Seagate Dockstar in my case). I initially thought of Calibre2OPDS but as it generate static file no search was possible. Later I added an simple HTML catalog that should be usable on my Kobo. So COPS's main advantages are : * No need for many dependencies. * No need for a lot of CPU or RAM. * Not much code. * Search is available. * With Dropbox / owncloud it's very easy to have an up to date OPDS server. * It was fun to code. If you want to use the OPDS feed don't forget to specify /feed at the end of your URL. |
| 27 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/cura-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Cura](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Cura) | 5.11.0 | Free, easy-to-use 3D printing software trusted by millions of users. Fine-tune your 3D model with 400+ settings for the best slicing and printing results. |
| 28 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/darktable-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Darktable](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Darktable) | version-2025-07-12 | An open source photography workflow application and raw developer. A virtual lighttable and darkroom for photographers. It manages your digital negatives in a database, lets you view them through a zoomable lighttable and enables you to develop raw images and enhance them. |
| 29 | <img src="https://raw.githubusercontent.com/linuxserver/davos/master/docs/list.PNG" width="15"/>&nbsp;&nbsp;&nbsp;[Davos](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Davos) | 2.2.2 | An FTP automation tool that periodically scans given host locations for new files. It can be configured for various purposes, including listening for specific files to appear in the host location, ready for it to download and then move, if required. It also supports completion notifications as well as downstream API calls, to further the workflow. |
| 30 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/ddclient-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Ddclient](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Ddclient) | 4.0.0 | A Perl client used to update dynamic DNS entries for accounts on Dynamic DNS Network Service Provider. It was originally written by Paul Burry and is now mostly by wimpunk. It has the capability to update more than just dyndns and it can fetch your WAN-ipaddress in a few different ways. |
| 31 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/deluge-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Deluge](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Deluge) | 2.2.0 | A lightweight, Free Software, cross-platform BitTorrent client. * Full Encryption * WebUI * Plugin System * Much more. . . |
| 32 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/digikam.png" width="15"/>&nbsp;&nbsp;&nbsp;[Digikam](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Digikam) | 8.8.0 | digiKam: Professional Photo Management with the Power of Open Source |
| 33 | <img src="https://raw.githubusercontent.com/diskoverdata/diskover-community/master/diskover-web/public/images/diskover.png" width="15"/>&nbsp;&nbsp;&nbsp;[Diskover](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Diskover) | 2.3.4 | An open source file system indexer that uses Elasticsearch to index and manage data across heterogeneous storage systems. |
| 34 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/dogwalk-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Dogwalk](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Dogwalk) | 296bec48-ls29 | Blender Studio's long awaited second game project, focused on creating a bite-sized interactive storytelling playground. Play as a big adorable dog and explore the winter woods with a little kid. |
| 35 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/dokuwiki-icon.png" width="15"/>&nbsp;&nbsp;&nbsp;[Dokuwiki](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Dokuwiki) | version-2025-05-14b | A simple to use and highly versatile Open Source wiki software that doesn't require a database. It is loved by users for its clean and readable syntax. The ease of maintenance, backup and integration makes it an administrator's favorite. Built in access controls and authentication connectors make DokuWiki especially useful in the enterprise context and the large number of plugins contributed by its vibrant community allow for a broad range of use cases beyond a traditional wiki. |
| 36 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/dolphin-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Dolphin](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Dolphin) | version-c60bcc9b | Lets you play GameCube and Wii games with various graphical enhancements and other features are available to improve your game experience. |
| 37 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/doplarr-logo_title.png" width="15"/>&nbsp;&nbsp;&nbsp;[Doplarr](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Doplarr) | 3.7.0 | An *arr request bot for Discord. ' |
| 38 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/dosbox-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Dosbox staging](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Dosbox-staging) | 0.82.2 | A modern continuation of DOSBox a free and open-source emulator that enables the execution of MS-DOS software, especially video games. |
| 39 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/doublecommander-icon.png" width="15"/>&nbsp;&nbsp;&nbsp;[Doublecommander](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Doublecommander) | version-b6807321 | A free cross platform open source file manager with two panels side by side. It is inspired by Total Commander and features some new ideas. |
| 40 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/duckdns.png" width="15"/>&nbsp;&nbsp;&nbsp;[Duckdns](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Duckdns) | version-33acdda4 | A free service which will point a DNS (sub domains of duckdns. Org) to an IP of your choice. The service is completely free, and doesn't require reactivation or forum posts to maintain its existence. |
| 41 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/duckstation-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Duckstation](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Duckstation) | version-latest | A PS1 Emulator aiming for the best accuracy and game support. |
| 42 | <img src="https://github.com/linuxserver/docker-templates/raw/master/linuxserver.io/img/duplicati-icon.png" width="15"/>&nbsp;&nbsp;&nbsp;[Duplicati](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Duplicati) | 2.2.0 | A backup client that securely stores encrypted, incremental, compressed backups on local storage, cloud storage services and remote file servers. It works with standard protocols like FTP, SSH, WebDAV as well as popular services like Microsoft OneDrive, Amazon S3, Google Drive, box. Com, Mega, B2, and many others. |
| 43 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/emby-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Emby](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Emby) | 4.9.3 | Organizes video, music, live TV, and photos from personal media libraries and streams them to smart TVs, streaming boxes and mobile devices. This container is packaged as a standalone emby Media Server. |
| 44 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/fail2ban-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Fail2ban](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Fail2ban) | 1.1.0 | A daemon to ban hosts that cause multiple authentication errors. |
| 45 | <img src="https://cdn.jsdelivr.net/gh/WisdomSky/CasaOS-LinuxServer-AppStore@main/default-icon.svg" width="15"/>&nbsp;&nbsp;&nbsp;[Faster whisper](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Faster-whisper) | 3.1.0 | A reimplementation of OpenAI's Whisper model using CTranslate2, which is a fast inference engine for Transformer models. This container provides a Wyoming protocol server for faster-whisper. |
| 46 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/ferdium-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Ferdium](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Ferdium) | 7.1.1 | A desktop app that helps you organize how you use your favourite apps by combining them into one application. |
| 47 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/ffmpeg.png" width="15"/>&nbsp;&nbsp;&nbsp;[Ffmpeg](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Ffmpeg) | 8.0.1 | This container needs special attention. Please check https://hub. Docker. Com/r/linuxserver/ffmpeg for details. |
| 48 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/filezilla-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Filezilla](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Filezilla) | 3.68.1 | Client is a fast and reliable cross-platform FTP, FTPS and SFTP client with lots of useful features and an intuitive graphical user interface. |
| 49 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/firefox-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Firefox](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Firefox) | 1147.0.3 | Browser, also known as Mozilla Firefox or simply Firefox, is a free and open-source web browser developed by the Mozilla Foundation and its subsidiary, the Mozilla Corporation. Firefox uses the Gecko layout engine to render web pages, which implements current and anticipated web standards. |
| 50 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/flexget-banner.png" width="15"/>&nbsp;&nbsp;&nbsp;[Flexget](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Flexget) | 3.18.47 | A multipurpose automation tool for all of your media. |
| 51 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/flycast-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Flycast](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Flycast) | 2.6.20260208 | A multi-platform Sega Dreamcast, Naomi, Naomi 2, and Atomiswave emulator derived from reicast. |
| 52 | <img src="https://foldingathome.org/wp-content/uploads/2016/09/folding-at-home-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Foldingathome](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Foldingathome) | 8.5.5 | A distributed computing project for simulating protein dynamics, including the process of protein folding and the movements of proteins implicated in a variety of diseases. It brings together citizen scientists who volunteer to run simulations of protein dynamics on their personal computers. Insights from this data are helping scientists to better understand biology, and providing new opportunities for developing therapeutics. |
| 53 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/freecad-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Freecad](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Freecad) | 1.0.2 | A general-purpose parametric 3D computer-aided design (CAD) modeler and a building information modeling (BIM) software application with finite element method (FEM) support. |
| 54 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/freshrss-banner.png" width="15"/>&nbsp;&nbsp;&nbsp;[Freshrss](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Freshrss) | 1.28.1 | A free, self-hostable aggregator for rss feeds. |
| 55 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/gimp-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Gimp](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Gimp) | version-2a210179 | A free and open-source raster graphics editor used for image manipulation (retouching) and image editing, free-form drawing, transcoding between different image file formats, and more specialized tasks. It is extensible by means of plugins, and scriptable. |
| 56 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/github-desktop-icon.png" width="15"/>&nbsp;&nbsp;&nbsp;[Github desktop](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Github-desktop) | 3.4.13 | An open source Electron-based GitHub app. It is written in TypeScript and uses React. |
| 57 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/gitqlient-icon.png" width="15"/>&nbsp;&nbsp;&nbsp;[Gitqlient](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Gitqlient) | 1.6.3 | A multi-platform Git client originally forked from QGit. Nowadays it goes beyond of just a fork and adds a lot of new functionality. |
| 58 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/grav-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Grav](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Grav) | 1.7.49 | A Fast, Simple, and Flexible, file-based Web-platform. |
| 59 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/grocy-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Grocy](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Grocy) | 4.5.0 | An ERP system for your kitchen. Cut down on food waste, and manage your chores with this brilliant utility. Keep track of your purchases, how much food you are wasting, what chores need doing and what batteries need charging with this proudly Open Source tool For more information on grocy visit their website and check it out: https://grocy. Info |
| 60 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/gzdoom-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Gzdoom](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Gzdoom) | 4.14.2 | A feature centric port for all Doom engine games, based on ZDoom, adding an OpenGL renderer and powerful scripting capabilities. |
| 61 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/habridge-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Habridge](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Habridge) | 5.4.1 | Emulates Philips Hue API to other home automation gateways such as an Amazon Echo/Dot Gen 1 (gen 2 has issues discovering ha-bridge) or other systems that support Philips Hue. The Bridge handles basic commands such as On, Off and brightness commands of the hue protocol. This bridge can control most devices that have a distinct API. |
| 62 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/handbrake-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Handbrake](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Handbrake) | 1.10.2 | An open-source tool, built by volunteers, for converting video from nearly any format to a selection of modern, widely supported codecs. |
| 63 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/healthchecks-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Healthchecks](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Healthchecks) | 4.0.20260209 | A watchdog for your cron jobs. It's a web server that listens for pings from your cron jobs, plus a web interface. |
| 64 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/hedgedoc-banner.png" width="15"/>&nbsp;&nbsp;&nbsp;[Hedgedoc](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Hedgedoc) | 1.10.6 | Gives you access to all your files wherever you are. HedgeDoc is a real-time, multi-platform collaborative markdown note editor. This means that you can write notes with other people on your desktop, tablet or even on the phone. You can sign-in via multiple auth providers like Facebook, Twitter, GitHub and many more on the homepage. |
| 65 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/heimdall-banner.png" width="15"/>&nbsp;&nbsp;&nbsp;[Heimdall](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Heimdall) | 2.7.6 | A way to organise all those links to your most used web sites and web applications in a simple way. Simplicity is the key to Heimdall. Why not use it as your browser start page. It even has the ability to include a search bar using either Google, Bing or DuckDuckGo. |
| 66 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/hishtory-server-icon.png" width="15"/>&nbsp;&nbsp;&nbsp;[Hishtory server](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Hishtory-server) | 0.335.20260213 | A better shell history. It stores your shell history in context (what directory you ran the command in, whether it succeeded or failed, how long it took, etc). This is all stored locally and end-to-end encrypted for syncing to to all your other computers. |
| 67 | <img src="https://github.com/home-assistant/home-assistant.io/raw/next/source/images/favicon-192x192-full.png" width="15"/>&nbsp;&nbsp;&nbsp;[Homeassistant](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Homeassistant) | 2026.2.2 | Open source home automation that puts local control and privacy first. Powered by a worldwide community of tinkerers and DIY enthusiasts. Perfect to run on a Raspberry Pi or a local server |
| 68 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/htpcmanager-icon.png" width="15"/>&nbsp;&nbsp;&nbsp;[Htpcmanager](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Htpcmanager) | version-26a641bf | A front end for many htpc related applications. |
| 69 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/inkscape-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Inkscape](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Inkscape) | 1.4.2 | Professional quality vector graphics software which runs on Linux, Mac OS X and Windows desktop computers. |
| 70 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/intellij-idea-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Intellij idea](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Intellij-idea) | 42025.2.5 | Helps you write code faster with tools that eliminate tedious tasks and let you focus on what matters – building great software. |
| 71 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/jackett-banner.png" width="15"/>&nbsp;&nbsp;&nbsp;[Jackett](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Jackett) | 0.24.1113 | Works as a proxy server: it translates queries from apps (Sonarr, SickRage, CouchPotato, Mylar, etc) into tracker-site-specific http queries, parses the html response, then sends results back to the requesting software. This allows for getting recent uploads (like RSS) and performing searches. Jackett is a single repository of maintained indexer scraping & translation logic - removing the burden from other apps. |
| 72 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/jellyfin-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Jellyfin](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Jellyfin) | 10.11.6 | A Free Software Media System that puts you in control of managing and streaming your media. It is an alternative to the proprietary Emby and Plex, to provide media from a dedicated server to end-user devices via multiple apps. Jellyfin is descended from Emby's 3. 5. 2 release and ported to the. NET Core framework to enable full cross-platform support. There are no strings attached, no premium licenses or features, and no hidden agendas: just a team who want to build something better and work together to achieve it. |
| 73 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/joplin-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Joplin](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Joplin) | 3.5.12 | A free, open source note taking and to-do application, which can handle a large number of notes organised into notebooks. |
| 74 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/kali-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Kali linux](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Kali-linux) | version-289c0610 | is an Advanced Penetration Testing Linux distribution used for Penetration Testing, Ethical Hacking and network security assessments. KALI LINUX ™ is a trademark of OffSec. |
| 75 | <img src="https://kasm-ci.s3.amazonaws.com/kasm_wide.png" width="15"/>&nbsp;&nbsp;&nbsp;[Kasm](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Kasm) | 1.18.0 | Workspaces is a docker container streaming platform for delivering browser-based access to desktops, applications, and web services. Kasm uses devops-enabled Containerized Desktop Infrastructure (CDI) to create on-demand, disposable, docker containers that are accessible via web browser. Example use-cases include Remote Browser Isolation (RBI), Data Loss Prevention (DLP), Desktop as a Service (DaaS), Secure Remote Access Services (RAS), and Open Source Intelligence (OSINT) collections. The rendering of the graphical-based containers is powered by the open-source project KasmVNC. |
| 76 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/kavita-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Kavita](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Kavita) | 0.8.9 | A fast, feature rich, cross platform reading server. Built with a focus for being a full solution for all your reading needs. Setup your own server and share your reading collection with your friends and family. |
| 77 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/kdenlive-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Kdenlive](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Kdenlive) | 25.12.2 | A powerful free and open source cross-platform video editing program made by the KDE community. Feature rich and production ready. |
| 78 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/keepassxc-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Keepassxc](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Keepassxc) | 2.7.11 | A free and open-source password manager. It started as a community fork of KeePassX (itself a cross-platform port of KeePass). |
| 79 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/kicad-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Kicad](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Kicad) | 9.0.6 | A Cross Platform and Open Source Electronics Design Automation Suite. |
| 80 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/kimai-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Kimai](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Kimai) | 2.48.0 | A professional grade time-tracking application, free and open-source. It handles use-cases of freelancers as well as companies with dozens or hundreds of users. Kimai was build to track your project times and ships with many advanced features, including but not limited to: JSON API, invoicing, data exports, multi-timer and punch-in punch-out mode, tagging, multi-user - multi-timezones - multi-language (over 30 translations existing. ), authentication via SAML/LDAP/Database, two-factor authentication (2FA) with TOTP, customizable role and team permissions, responsive design, user/customer/project specific rates, advanced search & filtering, money and time budgets, advanced reporting, support for plugins and so much more. |
| 81 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/kometa-banner.png" width="15"/>&nbsp;&nbsp;&nbsp;[Kometa](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Kometa) | 2.3.0 | A powerful tool designed to give you complete control over your media libraries. With Kometa, you can take your customization to the next level, with granular control over metadata, collections, overlays, and much more. |
| 82 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/krita-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Krita](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Krita) | 5.2.15 | A professional FREE and open source painting program. It is made by artists that want to see affordable art tools for everyone. |
| 83 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/lazylibrarian-icon.png" width="15"/>&nbsp;&nbsp;&nbsp;[Lazylibrarian](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Lazylibrarian) | version-93325b2d | A program to follow authors and grab metadata for all your digital reading needs. It uses a combination of Goodreads Librarything and optionally GoogleBooks as sources for author info and book info. This container is based on the DobyTang fork. |
| 84 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/ldap-auth-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Ldap auth](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Ldap-auth) | 3.4.5 | Software is for authenticating users who request protected resources from servers proxied by nginx. It includes a daemon (ldap-auth) that communicates with an authentication server, and a webserver daemon that generates an authentication cookie based on the user’s credentials. The daemons are written in Python for use with a Lightweight Directory Access Protocol (LDAP) authentication server (OpenLDAP or Microsoft Windows Active Directory 2003 and 2012). |
| 85 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/libreoffice-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Libreoffice](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Libreoffice) | 25.8.1 | A free and powerful office suite, and a successor to OpenOffice. Org (commonly known as OpenOffice). Its clean interface and feature-rich tools help you unleash your creativity and enhance your productivity. |
| 86 | <img src="https://raw.githubusercontent.com/librespeed/speedtest/master/.logo/logo3.png" width="15"/>&nbsp;&nbsp;&nbsp;[Librespeed](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Librespeed) | 5.5.1 | A very lightweight Speedtest implemented in Javascript, using XMLHttpRequest and Web Workers. No Flash, No Java, No Websocket, No Bullshit. |
| 87 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/librewolf-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Librewolf](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Librewolf) | 147.0.3 | A custom and independent version of Firefox, with the primary goals of privacy, security and user freedom. LibreWolf also aims to remove all the telemetry, data collection and annoyances, as well as disabling anti-freedom features like DRM. |
| 88 | <img src="https://github.com/lidarr/Lidarr/raw/develop/Logo/400.png" width="15"/>&nbsp;&nbsp;&nbsp;[Lidarr](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Lidarr) | 3.1.0 | A music collection manager for Usenet and BitTorrent users. It can monitor multiple RSS feeds for new tracks from your favorite artists and will grab, sort and rename them. It can also be configured to automatically upgrade the quality of files already downloaded when a better quality format becomes available. |
| 89 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/limnoria-icon.png" width="15"/>&nbsp;&nbsp;&nbsp;[Limnoria](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Limnoria) | 2026.1.16 | A robust, full-featured, and user/programmer-friendly Python IRC bot, with many existing plugins. Successor of the well-known Supybot. |
| 90 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/lollypop-icon.png" width="15"/>&nbsp;&nbsp;&nbsp;[Lollypop](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Lollypop) | 1.4.45 | A lightweight modern music player designed to work excellently on the GNOME desktop environment. |
| 91 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/minetest-icon.png" width="15"/>&nbsp;&nbsp;&nbsp;[Luanti](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Luanti) | 5.15.1 | (formerly Minetest) is an open source voxel game-creation platform with easy modding and game creation |
| 92 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/lychee-icon.png" width="15"/>&nbsp;&nbsp;&nbsp;[Lychee](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Lychee) | 7.3.2 | A free photo-management tool, which runs on your server or web-space. Installing is a matter of seconds. Upload, manage and share photos like from a native application. Lychee comes with everything you need and all your photos are stored securely. |
| 93 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/mame-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Mame](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Mame) | version-0.285dfsg1-0 | A free and open-source emulator designed to emulate the hardware of arcade games, video game consoles, old computers and other systems in software on modern personal computers. |
| 94 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/manyfold-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Manyfold](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Manyfold) | 0.132.1 | An open source, self-hosted web application for managing a collection of 3D models, particularly focused on 3D printing. |
| 95 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/mariadb-git.png" width="15"/>&nbsp;&nbsp;&nbsp;[Mariadb](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Mariadb) | 11.4.8 | One of the most popular database servers. Made by the original developers of MySQL. |
| 96 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/mastodon-banner.png" width="15"/>&nbsp;&nbsp;&nbsp;[Mastodon](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Mastodon) | 4.5.6 | A free, open-source social network server based on ActivityPub where users can follow friends and discover new ones. . |
| 97 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/mediaelch-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Mediaelch](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Mediaelch) | 2.12.0 | A MediaManager for Kodi. Information about Movies, TV Shows, Concerts and Music are stored as nfo files. Fanarts are downloaded automatically from fanart. Tv. Using the nfo generator, MediaElch can be used with other MediaCenters as well. |
| 98 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/medusa-icon.png" width="15"/>&nbsp;&nbsp;&nbsp;[Medusa](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Medusa) | 1.0.25 | An automatic Video Library Manager for TV Shows. It watches for new episodes of your favorite shows, and when they are posted it does its magic. |
| 99 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/melonds-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Melonds](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Melonds) | 1.1.20260209 | Aims at providing fast and accurate Nintendo DS emulation. |
| 100 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/minisatip-icon.png" width="15"/>&nbsp;&nbsp;&nbsp;[Minisatip](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Minisatip) | 2.0.71 | A multi-threaded satip server version 1. 2 that runs under Linux and it was tested with DVB-S, DVB-S2, DVB-T, DVB-T2, DVB-C, DVB-C2, ATSC and ISDB-T cards. |
| 101 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/linuxserver-ls-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Modmanager](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Modmanager) | version-b3d6b63f | This container needs special attention. Please check https://hub. Docker. Com/r/linuxserver/modmanager for details. |
| 102 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/modrinth-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Modrinth](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Modrinth) | 0.10.27 | A unique, open source launcher that allows you to play your favorite mods, and keep them up to date, all in one neat little package. |
| 103 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/monica-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Monica](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Monica) | 4.1.2 | An open source personal relationship management system, that lets you document your life. |
| 104 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/edge-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Msedge](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Msedge) | 145.0.3800 | A cross-platform web browser developed by Microsoft and based on Chromium. |
| 105 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/mstream-icon.png" width="15"/>&nbsp;&nbsp;&nbsp;[Mstream](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Mstream) | 5.13.1 | A personal music streaming server. You can use mStream to stream your music from your home computer to any device, anywhere. There are mobile apps available for both Android and iPhone. |
| 106 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/mullvad-browser-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Mullvad browser](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Mullvad-browser) | 15.0.4 | The Mullvad Browser is a privacy-focused web browser developed in a collaboration between Mullvad VPN and the Tor Project. It’s designed to minimize tracking and fingerprinting. You could say it’s a Tor Browser to use without the Tor Network. Instead, you can use it with a trustworthy VPN. |
| 107 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/mylar-icon.png" width="15"/>&nbsp;&nbsp;&nbsp;[Mylar3](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Mylar3) | 0.8.3 | An automated Comic Book downloader (cbr/cbz) for use with NZB and torrents written in python. It supports SABnzbd, NZBGET, and many torrent clients in addition to DDL. |
| 108 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/mysql-workbench-icon.png" width="15"/>&nbsp;&nbsp;&nbsp;[Mysql workbench](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Mysql-workbench) | 8.0.46 | A unified visual tool for database architects, developers, and DBAs. MySQL Workbench provides data modeling, SQL development, and comprehensive administration tools for server configuration, user administration, backup, and much more. |
| 109 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/netbox-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Netbox](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Netbox) | 4.5.2 | An IP address management (IPAM) and data center infrastructure management (DCIM) tool. Initially conceived by the network engineering team at DigitalOcean, NetBox was developed specifically to address the needs of network and infrastructure engineers. It is intended to function as a domain-specific source of truth for network operations. |
| 110 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/nextcloud-icon.png" width="15"/>&nbsp;&nbsp;&nbsp;[Nextcloud](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Nextcloud) | 32.0.6 | Gives you access to all your files wherever you are. Where are your photos and documents. With Nextcloud you pick a server of your choice, at home, in a data center or at a provider. And that is where your files will be. Nextcloud runs on that server, protecting your data and giving you access from your desktop or mobile devices. Through Nextcloud you also access, sync and share your existing data on that FTP drive at the office, a Dropbox or a NAS you have at home. |
| 111 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/nginx-banner.png" width="15"/>&nbsp;&nbsp;&nbsp;[Nginx](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Nginx) | 1.28.2 | A simple webserver with php support. The config files reside in /config for easy user customization. |
| 112 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/ngircd-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Ngircd](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Ngircd) | version-27-r1 | A free, portable and lightweight Internet Relay Chat server for small or private networks, developed under the GNU General Public License (GPL). It is easy to configure, can cope with dynamic IP addresses, and supports IPv6, SSL-protected connections as well as PAM for authentication. It is written from scratch and not based on the original IRCd. |
| 113 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/nzbget-banner.png" width="15"/>&nbsp;&nbsp;&nbsp;[Nzbget](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Nzbget) | 26.0.20260213 | A usenet downloader, written in C++ and designed with performance in mind to achieve maximum download speed by using very little system resources. |
| 114 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/hydra-icon.png" width="15"/>&nbsp;&nbsp;&nbsp;[Nzbhydra2](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Nzbhydra2) | 8.5.1 | A meta search application for NZB indexers, the spiritual successor to NZBmegasearcH, and an evolution of the original application NZBHydra. It provides easy access to a number of raw and newznab based indexers. |
| 115 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/obsidian-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Obsidian](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Obsidian) | 1.11.7 | A note-taking app that lets you create, link, and organize your notes on your device, with hundreds of plugins and themes to customize your workflow. You can also publish your notes online, access them offline, and sync them securely with end-to-end encryption. |
| 116 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/ombi.png" width="15"/>&nbsp;&nbsp;&nbsp;[Ombi](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Ombi) | 4.53.4 | Allows you to host your own Plex Request and user management system. If you are sharing your Plex server with other users, allow them to request new content using an easy to manage interface. Manage all your requests for Movies and TV with ease, leave notes for the user and get notification when a user requests something. Allow your users to post issues against their requests so you know there is a problem with the audio etc. Even automatically send them weekly newsletters of new content that has been added to your Plex server. |
| 117 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/onlyoffice-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Onlyoffice](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Onlyoffice) | 9.2.1 | Provides a full range of tools to create, edit and collaborate on text documents, spreadsheets, presentations, PDF forms and regular PDF files on web, desktop and mobile platforms. |
| 118 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/openshot-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Openshot](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Openshot) | 3.4.0 | Video Editor is an award-winning free and open-source video editor for Linux, Mac, and Windows, and is dedicated to delivering high quality video editing and animation solutions to the world. |
| 119 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/openssh-server-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Openssh server](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Openssh-server) | version-10.2_p1-r0 | A sandboxed environment that allows ssh access without giving keys to the entire server. Giving ssh access via private key often means giving full access to the server. This container creates a limited and sandboxed environment that others can ssh into. The users only have access to the folders mapped and the processes running inside this container. |
| 120 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/openvscode-server-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Openvscode server](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Openvscode-server) | 1.106.3 | Provides a version of VS Code that runs a server on a remote machine and allows access through a modern web browser. |
| 121 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/opera-icon.png" width="15"/>&nbsp;&nbsp;&nbsp;[Opera](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Opera) | 127.0.5778 | A multi-platform web browser developed by its namesake company Opera. The browser is based on Chromium, but distinguishes itself from other Chromium-based browsers (Chrome, Edge, etc. ) through its user interface and other features. |
| 122 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/orcaslicer-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Orcaslicer](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Orcaslicer) | 2.3.1 | An open source slicer for FDM printers. OrcaSlicer is fork of Bambu Studio, it was previously known as BambuStudio-SoftFever, Bambu Studio is forked from PrusaSlicer by Prusa Research, which is from Slic3r by Alessandro Ranellucci and the RepRap community |
| 123 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/oscam-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Oscam](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Oscam) | version-11943 | An Open Source Conditional Access Module software used for descrambling DVB transmissions using smart cards. It's both a server and a client. |
| 124 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/overseerr.png" width="15"/>&nbsp;&nbsp;&nbsp;[Overseerr](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Overseerr) | 1.34.0 | A request management and media discovery tool built to work with your existing Plex ecosystem. |
| 125 | <img src="https://raw.githubusercontent.com/schlagmichdoch/PairDrop/master/public/images/android-chrome-512x512.png" width="15"/>&nbsp;&nbsp;&nbsp;[Pairdrop](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Pairdrop) | 1.11.2 | A sublime alternative to AirDrop that works on all platforms. Send images, documents or text via peer to peer connection to devices in the same local network/Wi-Fi or to paired devices. |
| 126 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/pcsx2-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Pcsx2](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Pcsx2) | 2.6.2 | An open source PS2 Emulator. |
| 127 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/phpmyadmin-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Phpmyadmin](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Phpmyadmin) | 5.2.3 | A free software tool written in PHP, intended to handle the administration of MySQL over the Web. PhpMyAdmin supports a wide range of operations on MySQL and MariaDB. |
| 128 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/pidgin-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Pidgin](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Pidgin) | 2.14.14 | A chat program which lets you log into accounts on multiple chat networks simultaneously. This means that you can be chatting with friends on XMPP and sitting in an IRC channel at the same time. |
| 129 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/piper-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Piper](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Piper) | 2.2.2 | A fast, local neural text to speech system that sounds great and is optimized for the Raspberry Pi 4. This container provides a Wyoming protocol server for Piper. |
| 130 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/piwigo-banner.png" width="15"/>&nbsp;&nbsp;&nbsp;[Piwigo](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Piwigo) | 16.2.0 | A photo gallery software for the web that comes with powerful features to publish and manage your collection of pictures. |
| 131 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/planka-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Planka](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Planka) | 2.0.0 | An elegant open source project tracking tool. |
| 132 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/plex-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Plex](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Plex) | 1.43.0 | Organizes video, music and photos from personal media libraries and streams them to smart TVs, streaming boxes and mobile devices. This container is packaged as a standalone Plex Media Server. Straightforward design and bulk actions mean getting things done faster. |
| 133 | <img src="http://www.projectsend.org/wp-content/themes/projectsend/img/screenshots.png" width="15"/>&nbsp;&nbsp;&nbsp;[Projectsend](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Projectsend) | version-r1945 | A self-hosted application that lets you upload files and assign them to specific clients that you create yourself. Secure, private and easy. No more depending on external services or e-mail to send those files. |
| 134 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/prowlarr-banner.png" width="15"/>&nbsp;&nbsp;&nbsp;[Prowlarr](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Prowlarr) | 2.3.0 | A indexer manager/proxy built on the popular arr. Net/reactjs base stack to integrate with your various PVR apps. Prowlarr supports both Torrent Trackers and Usenet Indexers. It integrates seamlessly with Sonarr, Radarr, Lidarr, and Readarr offering complete management of your indexers with no per app Indexer setup required (we do it all). |
| 135 | <img src="https://raw.githubusercontent.com/kgretzky/pwndrop/master/media/pwndrop-logo-512.png" width="15"/>&nbsp;&nbsp;&nbsp;[Pwndrop](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Pwndrop) | 1.0.1 | A self-deployable file hosting service for sending out red teaming payloads or securely sharing your private files over HTTP and WebDAV. |
| 136 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/pycharm-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Pycharm](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Pycharm) | 2025.3.1 | Offers out-of-the-box support for Python, databases, Jupyter, Git, Conda, PyTorch, TensorFlow, Hugging Face, Django, Flask, FastAPI, and more. |
| 137 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/pydio-cells-icon.png" width="15"/>&nbsp;&nbsp;&nbsp;[Pydio cells](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Pydio-cells) | 4.4.17 | The nextgen file sharing platform for organizations. It is a full rewrite of the Pydio project using the Go language following a micro-service architecture. |
| 138 | <img src="https://github.com/linuxserver/docker-templates/raw/master/linuxserver.io/img/pyload-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Pyload ng](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Pyload-ng) | 0.5.0 | A Free and Open Source download manager written in Python and designed to be extremely lightweight, easily extensible and fully manageable via web. |
| 139 | <img src="https://github.com/linuxserver/docker-templates/raw/master/linuxserver.io/img/qbittorrent-icon.png" width="15"/>&nbsp;&nbsp;&nbsp;[Qbittorrent](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Qbittorrent) | 5.1.4 | The Qbittorrent project aims to provide an open-source software alternative to µTorrent. QBittorrent is based on the Qt toolkit and libtorrent-rasterbar library. |
| 140 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/qdirstat-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Qdirstat](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Qdirstat) | 2.0.20260201 | Qt-based directory statistics: KDirStat without any KDE -- from the author of the original KDirStat. |
| 141 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/qemu-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Qemu static](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Qemu-static) | 10.0.2 | This container needs special attention. Please check https://hub. Docker. Com/r/linuxserver/qemu-static for details. |
| 142 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/radarr.png" width="15"/>&nbsp;&nbsp;&nbsp;[Radarr](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Radarr) | 6.0.4 | A fork of Sonarr to work with movies à la Couchpotato. |
| 143 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/raneto-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Raneto](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Raneto) | 0.18.0 | is an open source Knowledgebase platform that uses static Markdown files to power your Knowledgebase. |
| 144 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/rawtherapee-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Rawtherapee](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Rawtherapee) | 5.12.20260208 | A free, cross-platform raw image processing program. |
| 145 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/remmina-icon.png" width="15"/>&nbsp;&nbsp;&nbsp;[Remmina](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Remmina) | 1.4.40 | A remote desktop client written in GTK, aiming to be useful for system administrators and travellers, who need to work with lots of remote computers in front of either large or tiny screens. Remmina supports multiple network protocols, in an integrated and consistent user interface. Currently RDP, VNC, SPICE, SSH and EXEC are supported. |
| 146 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/resilio-sync-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Resilio sync](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Resilio-sync) | 3.1.2 | (formerly BitTorrent Sync) uses the BitTorrent protocol to sync files and folders between all of your devices. There are both free and paid versions, this container supports both. There is an official sync image but we created this one as it supports user mapping to simplify permissions for volumes. |
| 147 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/retroarch-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Retroarch](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Retroarch) | 1.22.2 | A frontend for emulators, game engines and media players. It enables you to run classic games on a wide range of computers and consoles through its slick graphical interface. |
| 148 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/rpcs3-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Rpcs3](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Rpcs3) | version-build-9f928247218337313af5b1c2354dc77c49111399 | A multi-platform open-source Sony PlayStation 3 emulator and debugger written in C++ for Windows, Linux, macOS and FreeBSD. |
| 149 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/rsnapshot.png" width="15"/>&nbsp;&nbsp;&nbsp;[Rsnapshot](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Rsnapshot) | 1.4.5 | A filesystem snapshot utility based on rsync. Rsnapshot makes it easy to make periodic snapshots of local machines, and remote machines over ssh. The code makes extensive use of hard links whenever possible, to greatly reduce the disk space required. |
| 150 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/rustdesk-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Rustdesk](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Rustdesk) | 1.4.5 | A full-featured open source remote control alternative for self-hosting and security with minimal configuration. |
| 151 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/sabnzbd-banner.png" width="15"/>&nbsp;&nbsp;&nbsp;[Sabnzbd](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Sabnzbd) | 4.5.5 | Makes Usenet as simple and streamlined as possible by automating everything we can. All you have to do is add an. Nzb. SABnzbd takes over from there, where it will be automatically downloaded, verified, repaired, extracted and filed away with zero human interaction. |
| 152 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/scummvm-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Scummvm](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Scummvm) | 2026.1.0 | A program which allows you to run certain classic graphical adventure and role-playing games, provided you already have their data files. The clever part about this: ScummVM just replaces the executables shipped with the games, allowing you to play them on systems for which they were never designed. ScummVM is a complete rewrite of these games' executables and is not an emulator. |
| 153 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/selkies-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Sealskin](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Sealskin) | 0.1.35 | A self-hosted, client-server platform that enables users to run powerful, containerized desktop applications streamed directly to a web browser. It uses a browser extension to intercept user actions—such as clicking a link or downloading a file and redirects them to a secure, isolated application environment running on a remote server. |
| 154 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/shotcut-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Shotcut](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Shotcut) | 26.1.30 | A free, open source, cross-platform video editor. |
| 155 | <img src="https://raw.githubusercontent.com/wiki/SickGear/SickGear.Wiki/images/SickGearLogo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Sickgear](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Sickgear) | 3.34.11 | Provides management of TV shows and/or Anime, it detects new episodes, links downloader apps, and more. . For more information on SickGear visit their website and check it out: https://github. Com/SickGear/SickGear |
| 156 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/signal-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Signal](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Signal) | 7.89.0 | A messaging app with privacy at its core. It is free and easy to use, with strong end-to-end encryption that keeps your communication completely private. |
| 157 | <img src="https://github.com/linuxserver/docker-templates/raw/master/linuxserver.io/img/smokeping-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Smokeping](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Smokeping) | 2.9.0 | Keeps track of your network latency. For a full example of what this application is capable of visit UCDavis. |
| 158 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/docker-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Socket proxy](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Socket-proxy) | 3.2.12 | This container needs special attention. Please check https://hub. Docker. Com/r/linuxserver/socket-proxy for details. |
| 159 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/sonarr-banner.png" width="15"/>&nbsp;&nbsp;&nbsp;[Sonarr](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Sonarr) | 4.0.16 | (formerly NZBdrone) is a PVR for usenet and bittorrent users. It can monitor multiple RSS feeds for new episodes of your favorite shows and will grab, sort and rename them. It can also be configured to automatically upgrade the quality of files already downloaded when a better quality format becomes available. |
| 160 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/speedtest-tracker-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Speedtest tracker](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Speedtest-tracker) | 1.13.9 | A self-hosted internet performance tracking application that runs speedtest checks against Ookla's Speedtest service. |
| 161 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/spotube-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Spotube](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Spotube) | 5.1.0 | An open source, cross-platform Spotify client compatible across multiple platforms utilizing Spotify's data API and YouTube, Piped. Video or JioSaavn as an audio source, eliminating the need for Spotify Premium |
| 162 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/sqlitebrowser-banner.png" width="15"/>&nbsp;&nbsp;&nbsp;[Sqlitebrowser](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Sqlitebrowser) | 3.13.1 | A high quality, visual, open source tool to create, design, and edit database files compatible with SQLite. |
| 163 | <img src="https://github.com/linuxserver/docker-templates/raw/master/linuxserver.io/img/swag.gif" width="15"/>&nbsp;&nbsp;&nbsp;[Swag](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Swag) | 5.3.1 | SWAG - Secure Web Application Gateway (formerly known as letsencrypt, no relation to Let's Encrypt™) sets up an Nginx webserver and reverse proxy with php support and a built-in certbot client that automates free SSL server certificate generation and renewal processes (Let's Encrypt and ZeroSSL). It also contains fail2ban for intrusion prevention. |
| 164 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/synclounge-banner.png" width="15"/>&nbsp;&nbsp;&nbsp;[Synclounge](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Synclounge) | 5.2.35 | A third party tool that allows you to watch Plex in sync with your friends/family, wherever you are. |
| 165 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/syncthing-banner.png" width="15"/>&nbsp;&nbsp;&nbsp;[Syncthing](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Syncthing) | 2.0.14 | Replaces proprietary sync and cloud services with something open, trustworthy and decentralized. Your data is your data alone and you deserve to choose where it is stored, if it is shared with some third party and how it's transmitted over the Internet. |
| 166 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/syslog-ng-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Syslog ng](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Syslog-ng) | 4.10.2 | Allows you to flexibly collect, parse, classify, rewrite and correlate logs from across your infrastructure and store or route them to log analysis tools. |
| 167 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/tautulli-icon.png" width="15"/>&nbsp;&nbsp;&nbsp;[Tautulli](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Tautulli) | 2.16.0 | A python based web application for monitoring, analytics and notifications for Plex Media Server. |
| 168 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/telegram-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Telegram](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Telegram) | 6.5.1 | A cloud-based mobile and desktop messaging app. |
| 169 | <img src="https://raw.githubusercontent.com/thelounge/thelounge/master/client/img/logo-vertical-transparent-bg.svg?sanitize=true" width="15"/>&nbsp;&nbsp;&nbsp;[Thelounge](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Thelounge) | 4.4.3 | (a fork of shoutIRC) is a web IRC client that you host on your own server. |
| 170 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/thunderbird-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Thunderbird](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Thunderbird) | 1140.7.1 | A free and open-source personal information manager primarily used as an e-mail client with a calendar and contactbook, as well as an RSS feed reader, chat client, and news client. |
| 171 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/transmission.png" width="15"/>&nbsp;&nbsp;&nbsp;[Transmission](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Transmission) | 4.1.0 | Designed for easy, powerful use. Transmission has the features you want from a BitTorrent client: encryption, a web interface, peer exchange, magnet links, DHT, µTP, UPnP and NAT-PMP port forwarding, webseed support, watch directories, tracker editing, global and per-torrent speed limits, and more. |
| 172 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/tvheadend-big.png" width="15"/>&nbsp;&nbsp;&nbsp;[Tvheadend](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Tvheadend) | version-9968e6f3 | Works as a proxy server: is a TV streaming server and recorder for Linux, FreeBSD and Android supporting DVB-S, DVB-S2, DVB-C, DVB-T, ATSC, ISDB-T, IPTV, SAT>IP and HDHomeRun as input sources. Tvheadend offers the HTTP (VLC, MPlayer), HTSP (Kodi, Movian) and SAT>IP streaming. Multiple EPG sources are supported (over-the-air DVB and ATSC including OpenTV DVB extensions, XMLTV, PyXML). |
| 173 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/ubooquity-banner.png" width="15"/>&nbsp;&nbsp;&nbsp;[Ubooquity](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Ubooquity) | 3.1.0 | A free, lightweight and easy-to-use home server for your comics and ebooks. Use it to access your files from anywhere, with a tablet, an e-reader, a phone or a computer. |
| 174 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/ungoogled-chromium-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Ungoogled chromium](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Ungoogled-chromium) | 145.0.7632 | Google Chromium, sans dependency on Google web services. |
| 175 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/unifi-banner.png" width="15"/>&nbsp;&nbsp;&nbsp;[Unifi network-application](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Unifi-network-application) | 10.1.85 | The Unifi-network-application software is a powerful, enterprise wireless software engine ideal for high-density client deployments requiring low latency and high uptime performance. |
| 176 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/vivaldi-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Vivaldi](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Vivaldi) | 7.8.3925 | A Norwegian freeware, cross-platform web browser with a built-in email client developed by Vivaldi Technologies. |
| 177 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/vlc-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Vlc](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Vlc) | 3.0.21 | A free and open source cross-platform multimedia player and framework that delivers dependable performance across multiple devices. |
| 178 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/vscodium-icon.png" width="15"/>&nbsp;&nbsp;&nbsp;[Vscodium](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Vscodium) | 1.109.31074 | A community-driven, freely-licensed binary distribution of Microsoft’s editor VS Code. |
| 179 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/webcord-icon.png" width="15"/>&nbsp;&nbsp;&nbsp;[Webcord](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Webcord) | 4.12.1 | Can be summarized as a pack of security and privacy hardenings, Discord features reimplementations, Electron / Chromium / Discord bugs workarounds, stylesheets, internal pages and wrapped https://discord. Com page, designed to conform with ToS as much as it is possible (or hide the changes that might violate it from Discord's eyes). |
| 180 | <img src="https://www.webgrabplus.com/sites/default/themes/WgTheme/images/slideshows/EPG_fading.jpg" width="15"/>&nbsp;&nbsp;&nbsp;[Webgrabplus](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Webgrabplus) | 5.5.0 | A multi-site incremental xmltv epg grabber. It collects tv-program guide data from selected tvguide sites for your favourite channels. |
| 181 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/webtop-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Webtop](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Webtop) | arch-kde-version-2025-07-12 | Alpine, Ubuntu, Fedora, and Arch based containers containing full desktop environments in officially supported flavors accessible via any modern web browser. |
| 182 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/weixin-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Weixin](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Weixin) | version-3fe8a8c9 | (WeChat) is an instant messaging, social media, and mobile payment app developed by Tencent. |
| 183 | <img src="https://static.requarks.io/logo/wikijs-full.svg" width="15"/>&nbsp;&nbsp;&nbsp;[Wikijs](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Wikijs) | 2.5.312 | A modern, lightweight and powerful wiki app built on NodeJS. |
| 184 | <img src="https://www.wireguard.com/img/wireguard.svg" width="15"/>&nbsp;&nbsp;&nbsp;[Wireguard](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Wireguard) | 1.0.20250521 | An extremely simple yet fast and modern VPN that utilizes state-of-the-art cryptography. It aims to be faster, simpler, leaner, and more useful than IPsec, while avoiding the massive headache. It intends to be considerably more performant than OpenVPN. WireGuard is designed as a general purpose VPN for running on embedded interfaces and super computers alike, fit for many different circumstances. Initially released for the Linux kernel, it is now cross-platform (Windows, macOS, BSD, iOS, Android) and widely deployable. It is currently under heavy development, but already it might be regarded as the most secure, easiest to use, and simplest VPN solution in the industry. |
| 185 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/wireshark-icon.png" width="15"/>&nbsp;&nbsp;&nbsp;[Wireshark](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Wireshark) | 4.6.1 | The world’s foremost and widely-used network protocol analyzer. It lets you see what’s happening on your network at a microscopic level and is the de facto (and often de jure) standard across many commercial and non-profit enterprises, government agencies, and educational institutions. Wireshark development thrives thanks to the volunteer contributions of networking experts around the globe and is the continuation of a project started by Gerald Combs in 1998. |
| 186 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/wps-office-icon.png" width="15"/>&nbsp;&nbsp;&nbsp;[Wps office](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Wps-office) | 11.1.0 | A lightweight, feature-rich comprehensive office suite with high compatibility. As a handy and professional office software, WPS Office allows you to edit files in Writer, Presentation, Spreadsheet, and PDF to improve your work efficiency. |
| 187 | <img src="https://raw.githubusercontent.com/SergiX44/XBackBone/master/docs/img/xbackbone.png" width="15"/>&nbsp;&nbsp;&nbsp;[Xbackbone](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Xbackbone) | 3.8.1 | A simple, self-hosted, lightweight PHP file manager that support the instant sharing tool ShareX and *NIX systems. It supports uploading and displaying images, GIF, video, code, formatted text, and file downloading and uploading. Also have a web UI with multi user management, past uploads history and search support. |
| 188 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/xemu-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Xemu](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Xemu) | 0.8.133 | A free and open-source application that emulates the original Microsoft Xbox game console, enabling people to play their original Xbox games on Windows, macOS, and Linux systems. |
| 189 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/yaak-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Yaak](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Yaak) | 2026.2.1 | A desktop API client for organizing and executing REST, GraphQL, and gRPC requests. It's built using Tauri, Rust, and ReactJS. |
| 190 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/your_spotify-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Your_spotify](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Your_spotify) | 1.17.0 | A self-hosted application that tracks what you listen and offers you a dashboard to explore statistics about it. It's composed of a web server which polls the Spotify API every now and then and a web application on which you can explore your statistics. |
| 191 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/zen-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Zen](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Zen) | 1.18.7 | A free and open-source fork of Mozilla Firefox with a focus on privacy, customizability and design. |
| 192 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/znc-logo.png" width="15"/>&nbsp;&nbsp;&nbsp;[Znc](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Znc) | 1.10.1 | An IRC network bouncer or BNC. It can detach the client from the actual IRC server, and also from selected channels. Multiple clients from different locations can connect to a single ZNC account simultaneously and therefore appear under the same nickname on IRC. |
| 193 | <img src="https://raw.githubusercontent.com/linuxserver/docker-templates/master/linuxserver.io/img/zotero-icon.png" width="15"/>&nbsp;&nbsp;&nbsp;[Zotero](https://github.com/WisdomSky/CasaOS-LinuxServer-AppStore/tree/main/Apps/Zotero) | 7.0.32 | A free, easy-to-use tool to help you collect, organize, annotate, cite, and share research. |


## 😉 Check out our other Appstores

- [CasaOS Coolstore](https://github.com/WisdomSky/CasaOS-Coolstore) - Just an another CasaOS third-party Appstore with ❄Cool❄ apps. 

## Acknowledgements
* [technorabilia](https://github.com/technorabilia)

---

## Contributing

Contributing to this Appstore is temporarily not possible at the moment. Please refrain from submitting PRs into this repository.

Updates to this repository is auto-generated by a script.
