#!/usr/bin/env python3
#
# Copyright (C) 2016 g10 Code GmbH
# Copyright (C) 2004,2008 Igor Belyi <belyi@users.sourceforge.net>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, see <https://www.gnu.org/licenses/>.

# Sample of key deletion
# It deletes keys for joe@example.org generated by genkey.py script

from __future__ import absolute_import, print_function, unicode_literals

import gpg

del absolute_import, print_function, unicode_literals

with gpg.Context() as c:
    # Note: We must not modify the key store during iteration,
    # therefore, we explicitly make a list.
    keys = list(c.keylist("joe+gpg@example.org"))

    for k in keys:
        c.op_delete(k, True)
