# Pentest-Docker - Your Home Cloud Penetration System

![Vuldocker](./Images/Pentest-Docker.png)
<p align="center">
    <i>A Home Cloud Container Platform Built For Learning Penetration And Network Security</i>
</p>

![Desktop](./Images/Desktop.png)

## 🔥 Introduction

[中文介绍](./Readme-zh.md)

Pentest-Docker  is a  CasaOS third-party Appstore with Pentest-Tools apps.


---

### ❄ CasaOS Pentest-Docker URL

    https://github.com/arch3rPro/Pentest-Docker/archive/refs/heads/master.zip

## ✅ Installation

> CasaOS fully supports ZimaBoard, Intel NUC, and Raspberry Pi. Also, more computers and development boards and fully compatible with Ubuntu, Debian, Raspberry Pi OS, and CentOS with one-liner installation.

## Quick Setup

Freshly install a system from the list above and run this command:

```
wget -qO- https://get.casaos.io | sudo bash
```

or

```
curl -fsSL https://get.casaos.io | sudo bash
```

### AppStore

Go to your CasaOS dashboard.

![Dashbord](./Images/Dashboard.png)

Open the appstore and click `Add Source` button  located on the right just above the apps list.

![Appstore](./Images/Appstore.png)

Paste the appstore link `https://github.com/arch3rPro/Pentest-Docker/archive/refs/heads/master.zip` and then click `Add` to submit.

![AddLink](./Images/AddLink.png)

- Wait for the installation to finish. Done!

> **NOTE: Custom Appstore is only supported on CasaOS version [0.4.4](https://blog.casaos.io/blog/32.html) 

## 🛠 List of Applications

| Application                                                  | Version | Description                                                  |
| ------------------------------------------------------------ | ------- | ------------------------------------------------------------ |
| [Acunetix](https://github.com/arch3rPro/Pentest-Docker/tree/master/Apps/Acunetix) | 15.2    | Acunetix is an end-to-end web security scanner that offers a 360 view of an organization's security. |
| [Empire](https://github.com/arch3rPro/Pentest-Docker/tree/master/Apps/Empire) | 5.6.3   | Empire is a post-exploitation and adversary emulation framework that is used to aid Red Teams and Penetration Testers. |
| [Kunlun-M](https://github.com/arch3rPro/Pentest-Docker/tree/master/Apps/Kunlun-M) | 2.6.5   | KunLun-M is a complete open source static white-box scanning tool that supports semantic scanning of PHP and JavaScript, basic security, component security scanning, and basic scanning of Chrome Ext\Solidity. |
| [Pentest-Collaboration-Framework](https://github.com/arch3rPro/Pentest-Docker/tree/master/Apps/Pentest-Collaboration-Framework) | 1.4.8   | an opensource, cross-platform and portable toolkit for automating routine processes when carrying out various works for testing! |
| [Reverse-shell-generator](https://github.com/arch3rPro/Pentest-Docker/tree/master/Apps/Reverse-shell-generator) | 1.0.0   | Hosted Reverse Shell generator with a ton of functionality. -- (Great for CTFs) |
| [Viper](https://github.com/arch3rPro/Pentest-Docker/tree/master/Apps/Viper) | 1.6.4   | Viper is Redteam operation platform with webui.              |
| [Webmap](https://github.com/arch3rPro/Pentest-Docker/tree/master/Apps/WebMap) | master  | WebMap-Nmap Web Dashboard and Reporting.                     |
| [Next-Terminal](https://github.com/arch3rPro/Pentest-Docker/tree/master/Apps/Next-terminal) | 1.3.9   | Next Terminal is a simple, easy-to-use and secure open source interactive auditing system that supports RDP, SSH, VNC, Telnet, and Kubernetes protocols. |
| [NPS](https://github.com/arch3rPro/Pentest-Docker/tree/master/Apps/NPS) | 0.26.17 | a lightweight, high-performance, powerful intranet penetration proxy server, with a powerful web management terminal. |
| [Web-Check](https://github.com/Lissy93/web-check)            | master  | 🕵️‍♂️ All-in-one OSINT tool for analysing any website           |
| [BeEF](https://github.com/arch3rPro/Pentest-Docker/tree/master/Apps/BeEF) | 0.5.4.0 | The Browser Exploitation Framework Project.                  |

### Screenshot

- Acunetix (AWVS)

![](https://raw.githubusercontent.com/arch3rPro/Pentest-Docker/master/Apps/Acunetix/screenshot-01.png)

- Empire

![](https://raw.githubusercontent.com/arch3rPro/Pentest-Docker/master/Apps/Empire/thumbnail.png)

- Kunlun-M

![](https://raw.githubusercontent.com/arch3rPro/Pentest-Docker/master/Apps/Kunlun-M/screenshot-01.png)

- Pentest-Collaboration-Framework

![](https://raw.githubusercontent.com/arch3rPro/Pentest-Docker/master/Apps/Pentest-Collaboration-Framework/screenshot-04.png)

- Reverse-shell-generator

![](./Apps/Reverse-shell-generator/screenshot-1.png)

- Viper

![](https://raw.githubusercontent.com/arch3rPro/Pentest-Docker/master/Apps/Viper/screenshot-01.png)

- Web-Check

![](https://raw.githubusercontent.com/arch3rPro/Pentest-Docker/master/Apps/Web-Check/screenshot-1.png)

- BeEF

![](https://raw.githubusercontent.com/arch3rPro/Pentest-Docker/master/Apps/BeEF/screenshot-01.png)
