#!/bin/sh -e

vpc_peering_enabled="$(curl -s 169.254.169.254/metadata/v1/features/vpc_peering_enabled)"

if [ "${vpc_peering_enabled}" = "true" ]; then
        VPC_GATEWAY_IP=$(curl -s 169.254.169.254/metadata/v1/interfaces/private/0/ipv4/gateway)

        ip route replace 192.168.0.0/16 via ${VPC_GATEWAY_IP} dev eth1 mtu 1500 metric 101
        ip route replace 10.0.0.0/8 via ${VPC_GATEWAY_IP} dev eth1 mtu 1500 metric 101
        ip route replace 172.16.0.0/12 via ${VPC_GATEWAY_IP} dev eth1 mtu 1500 metric 101
fi
